% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneTonic-extras.R
\name{deseqresult2df}
\alias{deseqresult2df}
\title{Generate a table from the \code{DESeq2} results}
\usage{
deseqresult2df(res_de, FDR = NULL)
}
\arguments{
\item{res_de}{A \code{DESeqResults} object.}

\item{FDR}{Numeric value, specifying the significance level for thresholding
adjusted p-values. Defaults to NULL, which would return the full set of results
without performing any subsetting based on FDR.}
}
\value{
A tidy \code{data.frame} with the results from differential expression,
sorted by adjusted p-value. If FDR is specified, the table contains only genes
with adjusted p-value smaller than the value.
}
\description{
Generate a tidy table with the results of \code{DESeq2}
}
\examples{
data(res_de_macrophage, package = "GeneTonic")
head(res_macrophage_IFNg_vs_naive)
res_df <- mosdef::deresult_to_df(res_macrophage_IFNg_vs_naive)
head(res_df)
}
