% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_radar.R
\name{gs_radar}
\alias{gs_radar}
\alias{gs_spider}
\title{Radar (spider) plot for gene sets}
\usage{
gs_radar(
  res_enrich,
  res_enrich2 = NULL,
  n_gs = 20,
  p_value_column = "gs_pvalue"
)

gs_spider(
  res_enrich,
  res_enrich2 = NULL,
  n_gs = 20,
  p_value_column = "gs_pvalue"
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_enrich2}{Analogous to \code{res_enrich1}, another \code{data.frame} object,
storing the result of the functional enrichment analysis, but for a different
setting (e.g. another contrast).
Defaults to NULL (in this case, a single set of enrichment results is plotted).}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be displayed}

\item{p_value_column}{Character string, specifying the column of \code{res_enrich}
where the p-value to be represented is specified. Defaults to \code{gs_pvalue}
(it could have other values, in case more than one p-value - or an adjusted
p-value - have been specified).}
}
\value{
A \code{plotly} object
}
\description{
Radar (spider) plot for gene sets, either for one or more results from functional
enrichment analysis.
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)
gs_radar(res_enrich = res_enrich)
# or using the alias...
gs_spider(res_enrich = res_enrich)

# with more than one set
res_enrich2 <- res_enrich[1:60, ]
set.seed(42)
shuffled_ones <- sample(seq_len(60)) # to generate permuted p-values
res_enrich2$gs_pvalue <- res_enrich2$gs_pvalue[shuffled_ones]
# ideally, I would also permute the z scores and aggregated scores
gs_radar(
  res_enrich = res_enrich,
  res_enrich2 = res_enrich2
)
}
