% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_coord.R
\name{codon_coord}
\alias{codon_coord}
\alias{codon_coord,BaseGroup-method}
\alias{codon_coord,DNAStringSet_OR_NULL-method}
\alias{codon_coord,matrix_OR_data_frame-method}
\title{Codon coordinates on a given a given Abelian group representation.}
\usage{
codon_coord(codon = NULL, ...)

\S4method{codon_coord}{BaseGroup}(codon, group = NULL)

\S4method{codon_coord}{DNAStringSet_OR_NULL}(
  codon = NULL,
  filepath = NULL,
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  group = c("Z4", "Z5", "Z64", "Z125", "Z4^3", "Z5^3"),
  start = NA,
  end = NA,
  chr = 1L,
  strand = "+"
)

\S4method{codon_coord}{matrix_OR_data_frame}(
  codon,
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  group = c("Z64", "Z125", "Z4^3", "Z5^3")
)
}
\arguments{
\item{codon}{An object from \code{\link{BaseGroup-class}} (generated with
function \code{\link{base_coord}}), \code{\link[Biostrings]{DNAStringSet}}
or from \code{\link[Biostrings]{DNAMultipleAlignment}} class carrying the
DNA pairwise alignment of two sequences.}

\item{...}{Not in use.}

\item{group}{A character string denoting the group representation for the
given base or codon as shown in reference (2-3).}

\item{filepath}{A character vector containing the path to a file in
\emph{\strong{fasta}} format to be read. This argument must be given if
\emph{codon & base} arguments are not provided.}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2-3).}

\item{start, end, chr, strand}{Optional parameters required to build a
\code{\link[GenomicRanges]{GRanges-class}}. If not provided the default
values given for the function definition will be used.}
}
\value{
A \code{\link{CodonGroup-class}} object.
}
\description{
Given a string denoting a codon or base from the DNA (or RNA)
alphabet and a genetic-code Abelian group as given in reference (1).
}
\details{
Symbols "-" and "N" usually found in DNA sequence alignments to
denote gaps and missing/unknown bases are represented by the number: '-1'
on Z4 and '0' on Z5. In Z64 the symbol 'NA' will be returned for codons
including symbols "-" and "N".

This function returns a \code{\link[GenomicRanges]{GRanges-class}} object
carrying the codon sequence(s) and their respective coordinates in the
requested Abelian group or simply, when \emph{group =  'Z5^3'}
3D-coordinates, which are derive from Z5 as indicated in reference (3).
Notice that the coordinates can be 3D or just one-dimension ("Z64" or
"Z125"). Hence, the pairwise alignment provided in argument
\emph{\strong{codon}} must correspond to codon sequences.
}
\examples{
## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

## DNA base representation in the Abelian group Z5
bs_cor <- codon_coord(
    codon = aln,
    cube = "ACGT",
    group = "Z5"
)
bs_cor ## 3-D coordinates


## DNA base representation in the Abelian group Z64
bs_cor <- codon_coord(
    codon = aln,
    cube = "ACGT",
    group = "Z64"
)
bs_cor

## Giving a matrix of codons
codon_coord(base2codon(x = aln))

}
\references{
\enumerate{
\item Robersy Sanchez, Jesus Barreto (2021) Genomic Abelian Finite
Groups.
\href{https://doi.org/10.1101/2021.06.01.446543}{doi: 10.1101/2021.06.01.446543}
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 119-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560.
}
}
\seealso{
\href{https://github.com/genomaths/GenomeAlgebra_SymmetricGroup}{Symmetric Group of the Genetic-Code Cubes.}

\link{codon_matrix}, \link{base_coord} and \link{base2int}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
