% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotators.R
\docType{methods}
\name{annotateRegions}
\alias{annotateRegions}
\alias{annotateRegions,GInteractions,character,vector-method}
\title{Annotate regions}
\usage{
annotateRegions(GIObject, name, dat)

\S4method{annotateRegions}{GInteractions,character,vector}(GIObject, name, dat)
}
\arguments{
\item{GIObject}{A GenomicInteractions or GInteractions object}

\item{name}{Character. Will be used as a column name.}

\item{dat}{Vector of the same length as the GInteractions object,
containing data with which to annotate the object.}
}
\value{
invisible(1)
}
\description{
Use this function to add metadata parallel to the `regions` slot of a
GenomicInteractions or GInteractions object.
}
\examples{
data(hic_example_data)
chip <- runif(n = length(regions(hic_example_data)), max = 1000)
annotateRegions(hic_example_data, 'chip', chip)
}
