% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\docType{methods}
\name{export.chiasig}
\alias{export.chiasig}
\alias{export.chiasig,GInteractions-method}
\title{Export interactions in a BEDPE-like format for use with ChiaSig}
\usage{
export.chiasig(GIObject, fn = NULL, score = "counts")

\S4method{export.chiasig}{GInteractions}(GIObject, fn = NULL, score = "counts")
}
\arguments{
\item{GIObject}{A GInteractions object.}

\item{fn}{A filename to write the interactions data to}

\item{score}{Which metadata column to use as the score: counts or normalised}
}
\value{
invisible(1) if outputting to file or a data.frame containing all of the corresponding information
}
\description{
Exports a GInteractions object to BEDPE like format, (anchor specifications and a column for reads connecting them)
and writes to a specified file. If filename is not specified,
then a data.frame containing the information is returned. The value of the score parameter defines which field is used
to populate the score field.
}
\examples{
data(hic_example_data)
export.chiasig(hic_example_data, fn = tempfile(), score = 'counts')
}
