% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_self_ligation_threshold}
\alias{get_self_ligation_threshold}
\title{Get self ligation threshold with SD method from Heidari et al}
\usage{
get_self_ligation_threshold(
  GIObject,
  bins = 100,
  distance_th = 4e+05,
  plot = TRUE
)
}
\arguments{
\item{GIObject}{a GInteractions object of paired end reads}

\item{bins}{Number of evenly sized bins to use.}

\item{distance_th}{The threshold, in base pairs, to use as a cutoff to pick
which bins to use to determine the standard deviation.}

\item{plot}{TRUE by default. Whether to plot the log2ratio of opposite to
same strand reads vs distance.}
}
\value{
The cutoff in base pairs below which an interaction is likely to be a
  self ligation.
}
\description{
This function calculates a self ligation threshold according to the method
published in Heidari et al., Genome Research, 2014. Briefly, paired reads are
divided into in evenly sized bins. For each bin, the log2 ratio of reads that
are aligned to opposite strand vs to the same strand is calculated. Twice the
standard deviation of this ratio at high distances is used a cutoff to
determine which bins are likely to contain mostly self-liagted reads.
}
