% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_matrix_heatmap}
\alias{draw_matrix_heatmap}
\title{Display matrix as a heatmap}
\usage{
draw_matrix_heatmap(
  fullMatrix,
  dataName = "geneData",
  labels_col = NULL,
  levels_col = NULL,
  ranking = "Sum",
  ranges = NULL,
  verbose = FALSE
)
}
\arguments{
\item{fullMatrix}{a numeric matrix}

\item{dataName}{the nature of the numeric data}

\item{labels_col}{a named vector for column annotation}

\item{levels_col}{factor levels for names of labels_col, specifying the
order of labels_col}

\item{ranking}{method for ranking the rows of the input matrix, options are
c("Sum", "Max", "Hierarchical", "None")}

\item{ranges}{a numeric vector with three elements, defining custom range for
color ramp, default=NULL, i.e. the range is defined automatically based on
the c(minimun, median, maximum) of fullMatrix}

\item{verbose}{logical, whether to output the input matrix for inspection}
}
\value{
a grob object
}
\description{
Make a complex heatmap with column annotations
}
\examples{
fullMatrix <- matrix(rnorm(10000), ncol = 100)
for (i in seq_len(80)) {
    fullMatrix[i, 16:75] <- runif(60) + i
}
labels_col <- as.character(seq_len(100))
levels_col <- c("start", "center", "end")
names(labels_col) <- rep(levels_col, c(15, 60, 25))

draw_matrix_heatmap(fullMatrix, dataName = "test", labels_col, levels_col,
  ranges = c(-2, 0, 20))

}
\author{
Shuye Pu
}
