% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercions.R
\name{as.SpatialExperiment}
\alias{as.SpatialExperiment}
\alias{as.SpatialExperiment.NanoStringGeoMxSet}
\title{Convert Object to SpatialExperiment}
\usage{
as.SpatialExperiment(x, ...)

\method{as.SpatialExperiment}{NanoStringGeoMxSet}(
  x,
  normData = NULL,
  coordinates = NULL,
  forceRaw = FALSE,
  ...
)
}
\arguments{
\item{x}{GeoMxSet object to convert}

\item{...}{Arguments passed to other methods}

\item{normData}{assay containing normalized data}

\item{coordinates}{X and Y coordinates of each ROI, format: c(X,Y)}

\item{forceRaw}{should raw data be forced into SpatialExperiment, not recommended}
}
\value{
SpatialExperiment containing GeoMx data
}
\description{
Convert Object to SpatialExperiment

Convert GeoMxSet Object to SpatialExperiment
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data", 
                       package = "GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))

target_demoData <- aggregateCounts(demoData[1:1000,1:10])

target_demoData <- normalize(target_demoData, "quant")

seurat_demoData <- as.SpatialExperiment(target_demoData, 
                                        normData = "exprs_norm", 
                                        forceRaw = FALSE)

}
