% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc2_mthds.R
\name{MC2_Methods}
\alias{MC2_Methods}
\alias{mc2_mthds}
\title{List of level 2 multiple-concentration correction functions}
\usage{
mc2_mthds()
}
\value{
A list functions
}
\description{
\code{mc2_mthds} returns a list of correction/transformation functions
to be used during level 2 multiple-concentration processing.
}
\details{
The functions contained in the list returned by \code{mc2_mthds} return
a list of expressions to be executed in the \code{mc2} (not exported)
function environment. The functions are described here for reference
purposes, The \code{mc2_mthds} function is not exported, nor is it
intended for use.

All available methods are described in the Available Methods section, listed
by the function/method name.
}
\note{
This function is not exported and is not intended to be used by the user.
}
\section{Available Methods}{


More information about the level 2 multiple-concentration processing is
available in the package vignette, "Pipeline_Overview."

\describe{
  \item{log2}{Take the logarithm of cval with the base 2.}
  \item{log10}{Take the logarithm of cval with the base 10.}
  \item{rmneg}{Remove entries where cval is less than 0.}
  \item{rmzero}{Remove entries where cval is 0.}
  \item{mult25}{Multiply cval by 25.}
  \item{mult100}{Multiply cval by 100.}
  \item{negshift}{Shift cval by subtracting out the minimum of cval and
  adding 1, such that the new minimum of cval is 1.}
  \item{mult25}{Multiply cval by 2.5.}
  \item{mult3}{Multiply cval by 3.}
  \item{mult6}{Multiply cval by 6.}
}
}

\seealso{
\code{\link{mc2}}, \code{\link{Method functions}} to query what
methods get applied to each acid
}
\keyword{internal}
