% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteStudy.R
\name{deleteStudy}
\alias{deleteStudy}
\title{Completely remove all data for a study}
\usage{
deleteStudy(asid, db = NULL)
}
\arguments{
\item{asid}{The assay source/study ID}

\item{db}{(optional) the databse to delete from, defaults to the current
database settings}
}
\value{
None
}
\description{
\code{deleteStudy} completely removes all data for a study from the 
database.
}
\details{
Cannot be undone. Please use carefully. Not exported, as this is
intended for development and should not be used with real data.
}
\examples{

\dontrun{
## Load sample data
load(system.file("extdata", "data_for_vignette.rda", package="GladiaTOX"))

## Build assay table
assay <- buildAssayTab(plate, chnmap)

## Set study parameters
std.nm <- "SampleStudy" # study name
phs.nm <- "PhaseII" # study phase

## Load annotation in gtoxDB
loadAnnot(plate, assay, NULL)

## Delete previously loaded study data
asid = gtoxLoadAsid(fld=c("asnm", "asph"), val=list(std.nm, phs.nm))$asid
if(length(asid)>0){ deleteStudy(asid=asid) }
}

}
