% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxLoadWaid.R
\name{gtoxLoadWaid}
\alias{gtoxLoadWaid}
\title{Load well annotation information}
\usage{
gtoxLoadWaid(fld = NULL, val = NULL)
}
\arguments{
\item{fld}{Character, the field(s) to query on}

\item{val}{List, vectors of values for each field to query on. Must be in
the same order as 'fld'.}
}
\value{
A data.table with the well annotation information for the given
parameters
}
\description{
\code{gtoxLoadWaid} queries the gtox database and returns the well annotation
information for the given field and values.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Prepare for analysis before QC + process data
gtoxLoadWaid()

## Reset configuration
options(conf_store)

}
