% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumericTrack-class.R
\docType{class}
\name{NumericTrack-class}
\alias{NumericTrack-class}
\alias{drawAxis,NumericTrack-method}
\alias{drawGrid,NumericTrack-method}
\title{NumericTrack class and methods}
\usage{
\S4method{drawAxis}{NumericTrack}(GdObject, from, to, ...)

\S4method{drawGrid}{NumericTrack}(GdObject, from, to)
}
\arguments{
\item{GdObject}{Object of \code{GdObject-class}.}

\item{from, to}{Numeric scalar, giving the range of genomic coordinates to
limit the tracks in. Note that \code{to} cannot be larger than \code{from.}}

\item{\dots}{Additional arguments.}
}
\value{
A virtual class: No objects may be created from it.
}
\description{
The virtual parent class for all track items in the Gviz package designed to
contain numeric data. This class merely exists for dispatching purpose.
}
\section{Functions}{
\itemize{
\item \code{drawAxis(NumericTrack)}: add a y-axis to the title panel of a track.

\item \code{drawGrid(NumericTrack)}: superpose a grid on top of a track.

}}
\section{Slots}{

\describe{
\item{\code{dp}}{Object of \code{DisplayPars-class}, the display settings controlling the
look and feel of a track. See settings for details on setting graphical
parameters for tracks.}

\item{\code{name}}{Object of class \code{character}, a human-readable name for the track
that will be used in the track's annotation panel if necessary.}

\item{\code{imageMap}}{Object of \code{ImageMap-class}, containing optional information
for an HTML image map. This will be created by the \code{drawGD} methods when the
track is plotted to a device and is usually not set by the user.}

\item{\code{range}}{Object of class \code{GRanges}, the genomic ranges of the track items
as well as additional annotation information in its \code{elementMetaData} slot.
Please not that the slot is actually implemented as a class union between
\code{GRanges} and IRanges to increase efficiency, for instance for DataTrack
objects. This usually does not concern the user.}

\item{\code{chromosome}}{Object of class \code{character}, the chromosome on which the
track is defined. There can only be a single chromosome for one track. For
certain subclasses, the space of allowed chromosome names is limited (e.g.,
only those chromosomes that exist for a particular genome). Throughout the
package, chromosome name have to be entered either as a single integer scalar
or as a character scalar of the form chrXYZ, where XYZ may be an arbitrary
character string.}

\item{\code{genome}}{Object of class \code{character}, the genome for which the track is
defined. For most sub-classes this has to be valid UCSC genome identifier,
however this may not always be formally checked upon object instantiation.}
}}

\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
