% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructData.R
\name{reconstructData}
\alias{reconstructData}
\title{Reconstruct corrected data from Harman results}
\usage{
reconstructData(object, this = "corrected")
}
\arguments{
\item{object}{An instance of \code{harmanresults}.}

\item{this}{string, legal values are \code{original} or \code{corrected}.}
}
\value{
\code{matrix} of data
}
\description{
Method which reverts the PCA factorisation for instances of
\code{\link{harmanresults}}. This allows the original or corrected data to be
returned back from the PCA domain into the original data domain.
}
\examples{
library(HarmanData)
data(OLF)
expt <- olf.info$Treatment
batch <- olf.info$Batch
olf.harman <- harman(olf.data, expt, batch)
olf.data.corrected <- reconstructData(olf.harman)
}
\seealso{
\code{\link{harman}} \code{\link{harmanresults}}
}
