% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicdc2hic.R
\name{hicdc2hic}
\alias{hicdc2hic}
\title{hicdc2hic}
\usage{
hicdc2hic(
  gi_list,
  hicfile,
  mode = "normcounts",
  chrs = NULL,
  gen_ver = "hg19",
  memory = 8
)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects where each object
named with chromosomes contains intra-chromosomal interaction information
(minimally containing counts and genomic distance in \code{mcols(gi_list)}---
see \code{?gi_list_validate} for a detailed explanation of valid
\code{gi_list} instances).}

\item{hicfile}{the path to the .hic file}

\item{mode}{What to put to the .hic file
as score. Allowable options are: 'pvalue' for -log10 significance p-value,
'qvalue' for -log10 FDR corrected p-value,
'normcounts' for raw counts/expected counts, and
'zvalue' for standardized counts (raw counts-expected counts)/modeled
standard deviation of expected counts
and 'raw' to pass-through 'raw counts. Defaults to 'normcounts'.}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to chromosomes in \code{gi_list}.}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}}

\item{memory}{Java memory to generate .hic files. Defaults to 8. Up to 64 is recommended for higher resolutions.}
}
\value{
path of the .hic file.
}
\description{
This function converts various modes from HiCDCPlus gi_list (uniformly binned)
instance back into a .hic file with the \code{mode} passed
as counts that can be retrieved using Juicer Dump
(https://github.com/aidenlab/juicer/wiki/Data-Extraction)
with 'NONE' normalization.
}
\examples{
outdir<-paste0(tempdir(check=TRUE),'/')
gi_list<-generate_binned_gi_list(50e3,chrs='chr22')
gi_list<-add_hic_counts(gi_list,
hic_path=system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus"))
hicdc2hic(gi_list,hicfile=paste0(outdir,'out.hic'),
mode='raw')
}
