% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-methods.R
\name{export-methods}
\alias{export-methods}
\alias{export}
\alias{export,HiCExperiment,missing,character-method}
\title{HiCExperiment export methods}
\usage{
\S4method{export}{HiCExperiment,missing,character}(object, prefix, format, ...)
}
\arguments{
\item{object}{A HiCExperiment object}

\item{prefix}{Prefix used when generating output file(s).}

\item{format}{File format. Available: \code{cool} and \code{HiC-Pro}.}

\item{...}{Extra arguments to use when exporting to \code{cool}.
Can be \verb{metadata <string>} or \verb{chunksize <integer>}.}
}
\value{
Path to saved files
}
\description{
Export methods to save a HiCExperiment object into a set of HiC-Pro-style
files (matrix & regions files)
}
\examples{
################################################################
## ----------- Importing .(m)cool contact matrices ---------- ##
################################################################

mcoolPath <- HiContactsData::HiContactsData('yeast_wt', 'mcool')
hic <- import(mcoolPath, format = 'mcool', resolution = 16000)
export(hic["II"], prefix = 'subset_chrII', format = 'cool')
export(hic["II"], prefix = 'subset_chrII', format = 'HiC-Pro')
}
