% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{sparse2full}
\alias{sparse2full}
\title{Transform a sparse upper triangular matrix to a full Hi-C contact matrix}
\usage{
sparse2full(sparse.mat, hic.table = FALSE, column.name = NA)
}
\arguments{
\item{sparse.mat}{A matrix in sparse upper triangular format.}

\item{hic.table}{Logical, is your sparse.mat a hic.table?}

\item{column.name}{Character, Required if hic.table set to TRUE; The column
name of the hic.table that you want placed into the cells of the full matrix.
i.e. IF1, or p.value.}
}
\value{
A full Hi-C contact Matrix.
}
\description{
sparse2full will transform a sparse upper triangular Hi-C matrix
    to a full Hi-C chromatin contact matrix. If you are entering a
    simple sparse matrix, i.e. there are only 3 columns leave
    hic.table = FALSE and column.name = NA. If you wish to transform  a Hi-C
    matrix in hic.table object format into a full matrix then set
    hic.table = TRUE. You will then need to specify the column name that you
    wish to be entered as the values for the cells in the full matrix using
    the column.name option.
}
\examples{
data('NHEK.chr22')
full.mat <- sparse2full(NHEK.chr22)

}
