% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SwitchMatrix.R
\name{SwitchMatrix}
\alias{SwitchMatrix}
\title{Change values of HiC map.}
\usage{
SwitchMatrix(hicLst, matrixKind = c("obs", "norm", "o/e", "exp"))
}
\arguments{
\item{hicLst}{<List\link[InteractionSet:ContactMatrix-class]{ContactMatrix}>:
The HiC maps list.}

\item{matrixKind}{\if{html}{\out{<character>}}: The kind of matrix you want.}
}
\value{
A ContactMatrix list.
}
\description{
Change values in matrix with observed, balanced,
observed/expected or expected values according to what are be done in hic.
}
\details{
SwitchMatrix
}
\examples{
# Data
data(HiC_Ctrl.cmx_lst)

# Preprocess HiC
HiC.cmx_lst <- HiC_Ctrl.cmx_lst |>
    BalanceHiC(
        interactionType = "cis",
        method = "ICE"
    ) |>
    OverExpectedHiC()

# Switch values in matrix
HiC_Ctrl_Obs.cmx_lst <- SwitchMatrix(HiC.cmx_lst, matrixKind = "obs")
HiC_Ctrl_Norm.cmx_lst <- SwitchMatrix(HiC.cmx_lst, matrixKind = "norm")
HiC_Ctrl_oe.cmx_lst <- SwitchMatrix(HiC.cmx_lst, matrixKind = "o/e")
HiC_Ctrl_exp.cmx_lst <- SwitchMatrix(HiC.cmx_lst, matrixKind = "exp")

}
