% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ratesFirstGuess-methods.R
\name{ratesFirstGuess}
\alias{ratesFirstGuess}
\alias{ratesFirstGuess,INSPEcT-method}
\title{Retrieve pre-modeling rates and concentrations}
\usage{
ratesFirstGuess(object, feature)

\S4method{ratesFirstGuess}{INSPEcT}(object, feature)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{feature}{A character indicating the feature to retireve, "synthesis", "degradation", "processing" for rates, "total" for total mRNA concentrations or "preMRNA" for premature mRNA concentrations}
}
\value{
A numeric matrix containing the values for the selected feature
}
\description{
This method allow to access to the estimated synthesis, degradation, processing rates and pre mRNA and total mRNA 
concentrations the way they were calculated by the constructor function \code{\link{newINSPEcT}}.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))

ratesFirstGuess(nascentInspObj10, 'total')
ratesFirstGuess(nascentInspObj10, 'preMRNA')
ratesFirstGuess(nascentInspObj10, 'synthesis')
}
\seealso{
\code{\link{newINSPEcT}}, \code{\link{ratesFirstGuessVar}}
}
