% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rocThresholds-methods.R
\name{rocThresholds}
\alias{rocThresholds}
\alias{rocThresholds,INSPEcT_model,INSPEcT-method}
\title{Display rate classification performance with thresholds visible at x-axis}
\usage{
rocThresholds(object, object2, xlim = c(1e-05, 1), plot = TRUE)

\S4method{rocThresholds}{INSPEcT_model,INSPEcT}(object, object2, xlim = c(1e-05, 1), plot = TRUE)
}
\arguments{
\item{object}{An object of class INSPEcT_model, with true rates}

\item{object2}{An object of class INSPEcT or INSPEcT_model, with modeled rates}

\item{xlim}{A numeric representing limits for the x-axis (default is c(1-e-5,1))}

\item{plot}{A logical that indicates whether to plot or not. (default=TRUE)}
}
\value{
The thresholds that maximize both sensitivity and specificity
}
\description{
A method to visualize the performance in the classification of synthesis, degradation
and processing rates based on the comparison of the original simulated rates and the one
obtained by the function \code{\link{modelRates}}. For each rate, classification performance is measured 
in terms of sensitivity and specificity using a ROC curve analysis. False negatives (FN) represent cases 
where the rate is identified as constant while it was simulated as varying. False positives (FP) represent 
cases where INSPEcT identified a rate as varying while it was simulated as constant. On the contrary, 
true positives (TP) and negatives (TN) are cases of correct classification of varying and constant rates, respectively. 
Consequently, at increasing brown p-values different sensitivity and specificity can be achieved.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  nascentInspObj <- readRDS(system.file(package='INSPEcT', 'nascentInspObj.rds'))
 
  simRates<-makeSimModel(nascentInspObj, 1000, seed=1)
   
  # newTpts<-simRates@params$tpts
  # nascentSim2replicates<-makeSimDataset(object=simRates
  #                                    ,tpts=newTpts
  #                                    ,nRep=3
  #                                    ,NoNascent=FALSE
  #                                    ,seed=1)
  # nascentSim2replicates<-modelRates(nascentSim2replicates[1:100]
  #                                ,seed=1)
  # (not evaluated to save computational time)
 
  data("nascentSim2replicates",package='INSPEcT')
 
  rocThresholds(simRates[1:100],nascentSim2replicates)
}
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}, \code{\link{rocCurve}}
}
