% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_sumstat.R
\name{chisq_sumstat}
\alias{chisq_sumstat}
\title{Compute a gene-level multivariate Wald chi-square statistic using
summary-level genetic association and LD data.}
\usage{
chisq_sumstat(z_vec, w, R)
}
\arguments{
\item{z_vec}{A 2-vector for which the first entry is the TWAS z-score for
the first gene product, and the second entry is the TWAS z-score for the
second gene product (e.g. TWAS and PWAS z-scores).}

\item{w}{A 2 x p matrix of TWAS prediction model weights that are used to
generate the statistics required for the z_vec argument. The order of the
columns must match the order of the z_vec statistics. Weights should be
generated from standardized genotypes.}

\item{R}{A p x p LD correlation matrix containing pairwise correlations for
each SNP included in w.}
}
\value{
The value of approximated multivariate chi-square statistic.
}
\description{
Compute a gene-level multivariate Wald chi-square statistic using
summary-level genetic association and LD data.
}
\examples{
data(z_sumstats)
data(protwt_sumstats)
data(exprwt_sumstats)
data(ld_sumstats)
chisq_sumstat(z_vec = z_sumstats,w = cbind(protwt_sumstats,exprwt_sumstats),
R = ld_sumstats)
}
