\name{mdsChr22IntSpObj}
\alias{mdsChr22IntSpObj}
\docType{data}
\title{
	Object of SummarizedExperiment type for intron spanning reads of MDS data
}
\description{
The Results of \code{interest()} analysis in intron-spanning mode, for the 
genes that feature U12-type introns and are located on Chr22 in MDS data.
}
\usage{data(mdsChr22ExObj)}
\format{
An Object of class \code{SummarizedExperiment} that contains intron retention 
results generated by \code{interest()} function on MDS data consisting of 
bone-marrows samples of 8 MDS patients with ZRSR2 mutations, 4 patients without
the mutation and 4 healthy individuals.
  \describe{
    \item{\code{@colData}}{A "DataFrame" (from "S4Vectors" package) that its 
	rownames can be set as the sample identification names and the other 
	columns are various annotations for the samples. Its column names are 
	characters that describe the annotations.}
   \item{\code{@assays}}{List of size 2 that includes two numeric matrices: 
	\code{counts} that includes raw read counts of the sequencing reads 
	mapped to introns and exons, and (2) \code{scaledRetention}, i.e. the 
	normalized read counts.}
   \item{\code{@NAMES}}{A NULL value.}
	\item{\code{@elementMetadata}}{A "DataFrame" (from "S4Vectors" package) 
	that include intron and exon annotations.}
	\item{\code{@metadata}}{A list of size 2 that includes parameter settings 
	for the \code{interest()} and \code{interest.sequential()} runs.}
  }
}
\value{
Object of class \code{SummarizedExperiment}. 
}
\source{
Madan, V., et.al.,  Aberrant splicing of U12-type introns is the hallmark of 
ZRSR2 mutant myelodysplastic syndrome. Nat Communication 2015 Jan 14;6:6042. 
doi: 10.1038/ncomms7042.
}
\keyword{datasets}
