% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoCorrection.R
\name{IsoCorrection}
\alias{IsoCorrection}
\title{Algorithm For Natural Isotope Abundance And Tracer Purity Correction Of Data From Stable Isotope Labeling Experiments}
\usage{
IsoCorrection(MeasurementFile = NA, ElementFile = NA, MoleculeFile = NA,
  CorrectTracerImpurity = FALSE, CorrectTracerElementCore = TRUE,
  CalculateMeanEnrichment = TRUE, UltraHighRes = FALSE, DirOut = ".",
  FileOut = "result", FileOutFormat = "csv", ReturnResultsObject = TRUE,
  CorrectAlsoMonoisotopic = FALSE, CalculationThreshold = 10^-8,
  CalculationThreshold_UHR = 8, verbose = FALSE, Testmode = FALSE)
}
\arguments{
\item{MeasurementFile}{Required. The file that contains the measured data to
be corrected. Only ".xls",".xlsx" and ".csv" file formats are supported.}

\item{ElementFile}{Required. The file that contains the element information
required for correction. Only ".xls",".xlsx" and ".csv" file formats are
supported.}

\item{MoleculeFile}{Required. The file that contains the information on the
molecules for which data is to be corrected. Only ".xls",".xlsx" and ".csv"
file formats are supported.}

\item{CorrectTracerImpurity}{Logical. If TRUE, correction for isotopic
impurity of the tracer substrate is performed.}

\item{CorrectTracerElementCore}{Logical. If TRUE (recommended!), the tracer
element atoms in the core module (usually the part of the molecule that
does not come from derivatization) are considered when correcting.}

\item{CalculateMeanEnrichment}{Logical. If TRUE, the mean isotopic enrichment
is calculated for each molecule.}

\item{UltraHighRes}{Logical. If TRUE, high resolution correction is performed
on the data. Should only be set to TRUE, if you know that you have high
resolution data.}

\item{DirOut}{Character String. Defines the directory the corrected data and
log-file should be written to. Default directory is set to current working
directoy ('.').}

\item{FileOut}{Character String. Defines the name of the file that contains
the corrected data. The name of the fill will be
IsoCorrectoR_<FileOut>.<FileFormat>. If the format is set to "csv", the
name will also contain the type of the corrected data in the respective
file.}

\item{FileOutFormat}{Character String. Defines the format of the files that
contain the corrected data. Can either be "csv" or "xls". If set to "csv",
multiple files will be generated, one for each type of corrected data (eg.
corrected data, fractions, mean enrichment...). If set to "xls", all
correction results are provided in one excel file in different sheets.}

\item{ReturnResultsObject}{Logical. If TRUE, the correction results are
returned as a list in the current R_session in addition to writing the
results to a file. This is useful if the corrected data has to be further
processed directly in R.}

\item{CorrectAlsoMonoisotopic}{Logical. If TRUE, monoisotopic correction
results are also provided.}

\item{CalculationThreshold}{(Advanced Option) Numeric. Defines a threshold to
stop probability calculations at for making correction faster (normal
resolution mode). Should be left at the default value.}

\item{CalculationThreshold_UHR}{(Advanced Option) Numeric. Defines a
threshold to stop probability calculations at for making correction faster
(high resolution mode). Should be left at the default value.}

\item{verbose}{Logical. If TRUE, status messages are sent to standard output.}

\item{Testmode}{Logical. If TRUE, starts a testmode for development purposes.
Not required for users of IsoCorrectoR.}
}
\value{
The function returns a list with 4 elements

\describe{
 \item{success: }{string that is "TRUE" if the correction was successful, "FALSE" if an error occured and "WARNINGS"
 if warnings occured}
 \item{results: }{a list containing a dataframe for each type of corrected data (normal, fractions, mean enrichment ...).
 Will be NA if ReturnResultsObject is set to FALSE}
 \item{log: }{list containing log information on the correction run (parameters, file names and paths, warnings and errors)}
 \item{error: }{contains a string with the associated error message if an error occurred, empty otherwise}
}
}
\description{
\code{IsoCorrection} is the main function of the IsoCorrectoR package.
It performs the correction of mass spectrometry data from stable isotope
labeling experiments with regard to natural abundance and tracer purity.
Data from both MS and MS/MS experiments can be corrected
(with any tracer isotope: 13C, 15N, 18O...), as well as high resolution data
from multiple-tracer experiments (e.g. 13C and 15N used simultaneously).
}
\examples{

# Normal resolution data

   # 1) get path of example files
   path.molecule <- system.file("extdata","normal_resolution","MoleculeFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);
   path.element <- system.file("extdata","normal_resolution","ElementFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);
   path.measurement <- system.file("extdata","normal_resolution","MeasurementFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);

   # 2) run correction algorithm and save results in variable
   correctionResults <- IsoCorrection(MeasurementFile=path.measurement,
      ElementFile=path.element,
     MoleculeFile=path.molecule)

# High resolution data

   # 1) get path of example files
   path.molecule <- system.file("extdata","high_resolution","MoleculeFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);
   path.element <- system.file("extdata","high_resolution","ElementFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);
   path.measurement <- system.file("extdata","high_resolution","MeasurementFile.csv",
      package = "IsoCorrectoR", mustWork = TRUE);

   # 2) run correction algorithm and save results in variable
   correctionResults <- IsoCorrection(MeasurementFile=path.measurement,
      ElementFile=path.element,
     MoleculeFile=path.molecule,UltraHighRes=TRUE)

}
\references{
See Reference 1 \url{Link to IsoCorrectoR-Paper}
}
