% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyto_vis.R
\name{cyto_vis}
\alias{cyto_vis}
\title{Send graph to Cytoscape via CyREST}
\usage{
cyto_vis(graph_object, title = "Cytoscape Graph Window",
  edge_width_attribute = "summary_score", port.number = 1234)
}
\arguments{
\item{graph_object}{An igraph object such as the one generated by the 
function \code{\link{get_graph_object}}}

\item{title}{An optional title for the graph when it is in Cytoscape}

\item{edge_width_attribute}{The attribute that will be used for edge width; 
if data is not added or the attribute is not part of the graphing 
information, the edge width will default to 1.}

\item{port.number}{The port address for Cytoscape}
}
\value{
A dynamic map in Cytoscape automatically formatted for convenient 
viewing.
}
\description{
View the KEGG pathway in Cytoscape. With either the 
'expanded edges' or 'stacked nodes' layout, users can visualize and interact 
with the graphs [strictly] as they are documented in the most recent KGML
available from KEGG.  
This function is a modified version of the function send2cy(),
 which is part of the cyREST utility functions.
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML, FALSE)
nodes <- node_mapping_info(p53_KEGG_mappings)

p53_edges <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)
edges <- edge_mapping_info(p53_edges) 

p53_graph_object <- get_graph_object(nodes, edges)
                                      
\dontrun{
cyto_vis(p53_graph_object, "Default p53 Graph [no data added]")

#Workflow to visualize graph with data-dependent attributes:

p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML)
nodes <- node_mapping_info(p53_KEGG_mappings)

p53_edges <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)

p53_HA1E_data <- overlap_info(p53_KGML, p53_KEGG_mappings, "HA1E", 
                               data_type = "100_bing")
p53_edges_plus_data <- add_edge_data(p53_edges, p53_KEGG_mappings, 
                                      p53_HA1E_data, c(3, 10,12),
                                      only_mapped = TRUE)

edges <- edge_mapping_info(p53_edges_plus_data, data_added = TRUE)
                                            
p53_plus_data_graph_object <- get_graph_object(nodes, edges)
                                                
cyto_vis(p53_plus_data_graph_object, "p53 Graph: Mapped Edges + HA1E Data",
         edge_width_attribute = "UP")
         }
}
