% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_KEGG_mappings.R
\name{expand_KEGG_mappings}
\alias{expand_KEGG_mappings}
\title{Get detailed KEGG mapping information for each map entity}
\usage{
expand_KEGG_mappings(KGML_file, convert_KEGG_IDs = TRUE)
}
\arguments{
\item{KGML_file}{An object of formal class KEGGPathway}

\item{convert_KEGG_IDs}{A logical indicator; if set to FALSE will run faster
however genes and compounds will remain labeled via KEGG codes (compounds) 
or accession numbers (genes).  This option must be taken into account if 
data is being added.  For example, the genes in 'KO_data' are identified by
symbols, thus it is neccessary to retain the default option to convert IDs
to symbols when planning to add edge data of this type.}
}
\value{
A dataframe object with unique entry information for all [node]
 objects documented in the KEGG pathway. 
        Note that if mutiple objects (i.e. genes or compounds) have the same 
        entryID, this indicates that they share the same node [location] 
        in the pathway.
}
\description{
Extract mapping information from KGML object and normalize 
mappings based on multi-valued name attribute
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <-  expand_KEGG_mappings(p53_KGML, FALSE)
}
