% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fisher_info.R
\name{get_fisher_info}
\alias{get_fisher_info}
\title{Perform Fisher's Exact test for edges in pathway}
\usage{
get_fisher_info(edges, method)
}
\arguments{
\item{edges}{The set of eges to be analyzed; Although the intended use is for
LINCS data overlaps, the function should work with any typical data object as
long as it has columns labeled ("UP", "DOWN", "UK1_DK2", "DK1_UK2") that 
contain integer values.}

\item{method}{The method to correct/adjust p-values for multiple testing. 
For available methods, type 'p.adjust.methods' into command promt and 
press enter.}
}
\value{
The input edge data.frame object with additional columns containing
the results of the applied statistical test
}
\description{
Obtain a measure for strength and significance for the 
relationship (i.e. an edge) based on the concordance/discordance of 
UP-and-DOWN regulated genes shared by two different experimental 
gene-knockouts
Intended for use within \code{\link{overlap_info}}
}
\examples{
ex.data <- data.frame("UP" = c(70,6), "DOWN" = c(8,20),
                    "UK1_DK2" = c(4,47), "DK1_UK2" = c(3, 28))

overlaps <- get_fisher_info(ex.data, method = "BH")
}
