% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_methQTL.R
\name{doMethQTL}
\alias{doMethQTL}
\title{doMethQTL}
\usage{
doMethQTL(
  meth.qtl,
  sel.covariates = NULL,
  p.val.cutoff = 1e-05,
  ncores = 1,
  cluster.submit = FALSE,
  out.dir = getwd(),
  default.options = TRUE
)
}
\arguments{
\item{meth.qtl}{An object of type \code{\link{MethQTLInput-class}} on which methQTL computation is to be performed}

\item{sel.covariates}{Covariates as column names of the sample annotation sheet stored in \code{meth.qtl} to be
used for covariate adjustment.}

\item{p.val.cutoff}{The p-value cutoff used for methQTL calling}

\item{ncores}{The number of cores used.}

\item{cluster.submit}{Flag indicating if jobs are to be distributed among a SGE compute cluster}

\item{out.dir}{Output directory}

\item{default.options}{Flag indicating if default options for \code{cluster.cor.threshold},
\code{standard.deviation.gauss}, and \code{absolute.distance.cutoff} should be loaded for the
data set used. See the option settings in \code{'inst/extdata'}.}
}
\value{
An object of type \code{\link{MethQTLResult-class}} containing the called methQTL interactions.
}
\description{
Function to compute methQTL given DNA methylation and genotyping data.
}
\details{
The process is split into 4 steps:
           \describe{
           \item{1}{First the two matrices are split according to the chromosomes.}
           \item{2}{We then compute correlations among the CpGs and compute CpG correlation blocks.}
           \item{3}{In each of the CpG correlation blocks, linear models according to the \code{linear.model.type}
               \code{\link{qtlSetOption}} with the CpG methylation state of the reference CpG specified by
               \code{representative.cpg.computation} as output and the SNP genotype state and all possible covariates
               as input are computed.}
           \item{4}{For each of the CpG correlation blocks, we report the p-value of the representative CpG.}
           }
       Currently, if \code{qtlGetOption('cluster.architecture')=='sge'} the function does not return
       a \code{MethQTLResult} object, but \code{NULL}, since monitoring finished jobs is hard
       through SLURM. After the jobs are finished (checked using \code{squeue}), the results can
       can be loaded from \code{out.dir} using \code{\link{loadMethQTLResult}}.
}
\examples{
meth.qtl <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
meth.qtl.res <- doMethQTL(meth.qtl,p.val.cutoff=0.01)
}
\seealso{
doMethQTLChromosome
}
\author{
Michael Scherer
}
