% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fluidigm-methods.R
\name{freq}
\alias{freq}
\alias{condmean}
\alias{condSd}
\alias{numexp}
\title{Summary statistics for genes in an experiment}
\usage{
freq(sc, na.rm = TRUE)

condmean(sc)

condSd(sc)

numexp(sc)
}
\arguments{
\item{sc}{SingleCellAssay}

\item{na.rm}{should NAs be removed, or carried through?}
}
\value{
vector of proportions
}
\description{
\code{freq} returns the frequency of expression, i.e., the proportion of non-zero values in \code{sc}.
NAs can be optionally removed
}
\section{Functions}{
\itemize{
\item \code{condmean()}: Report the mean non-zero expression value for each gene. NAs are always removed.

\item \code{condSd()}: Report standard deviation of expression, for positive et for each gene. NAs are always removed.

\item \code{numexp()}: Report number of expressing cells ($>0$) per gene. NAs are removed.

}}
\examples{
data(vbetaFA)
freq(vbetaFA)
condmean(vbetaFA)
}
