% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecCLR}
\alias{mbecCLR}
\title{Centered Log-Ratio Transformation}
\usage{
mbecCLR(input.mtx, offset = 0)
}
\arguments{
\item{input.mtx}{A matrix of counts (samples x features).}

\item{offset}{An (OPTIONAL) offset in case of sparse matrix. Function will
add an offset of 1/#features if matrix is sparse and offset not provided.}
}
\value{
A matrix of transformed counts of same size and orientation as the
input.
}
\description{
Internal function that performs CLR-transformation on input-matrix.
Formula is: clr(mtx) = ln( mtx / geometric_mean(mtx_samples))
}
\keyword{Log}
\keyword{Ratio}
\keyword{Transformation}
