% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecMixedVariance}
\alias{mbecMixedVariance}
\title{Mixed Model Variance-Component Extraction}
\usage{
mbecMixedVariance(model.fit)
}
\arguments{
\item{model.fit}{A linear mixed model object of class 'lmerMod'.}
}
\value{
A named list, containing proportional variance for model terms that
describe mixed effects.
}
\description{
A helper function that extracts the variance components of linear mixed
models, i.e., residuals, random-effects, fixed-effects, scales them to
sample-size and returns a list of components.
}
\details{
Uses 'lme4::VarCorr' to extract Residuals and random-effects components.
Standard Deviation of Residuals is stored as 'sc' attribute in the output of
'VarCorr'.

Uses 'lme4::fixef' to extract fixed-effects components, i.e., parameter
estimates. The attribute 'pp' of the model contains the dense model matrix
for fixed-effects parameters (X). The fixed effects variance, sigma2f, is the
variance of the matrix-multiplication beta times X (parameter vector by
model matrix)
}
\examples{
# This will return the variance of random/mixed components.
data(dummy.list)
limimo <- lme4::lmer(dummy.list$cnts[,1] ~ group + (1|batch),
data=dummy.list$meta)
list.variance <- mbecMixedVariance(model.fit=limimo)
}
\keyword{lmm}
\keyword{proportion}
\keyword{variance}
