% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denovoDeletions.R
\name{denovoDeletions}
\alias{denovoDeletions}
\title{Denovo Deletion Calling}
\usage{
denovoDeletions(cbs, mCounts, bins)
}
\arguments{
\item{cbs}{The output from segmentMD().}

\item{mCounts}{The normalized counts matrix output by normalizeCounts().}

\item{bins}{The set of bins determined by calcBins().}
}
\value{
A \code{GRanges} object that reports all detected denovo deletions
passing requite filters.
}
\description{
This function will return a single GRanges object containing all denovo 
deletions that passed filtering from a Circular Binary Segmentation object 
with supplementary information.
}
\examples{
load(system.file("extdata", 'bins.RData', package = "MDTS"))
load(system.file("extdata", 'counts.RData', package = "MDTS"))
load(system.file("extdata", 'pD.RData', package = "MDTS"))
mCounts = normalizeCounts(counts, bins)
md = calcMD(mCounts, pD)
cbs = segmentMD(md, bins)
denovo = denovoDeletions(cbs, mCounts, bins)
}
\keyword{denovoDeletions}
