% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeCounts.R
\name{normalizeCounts}
\alias{normalizeCounts}
\title{Calculating the normalized M scores}
\usage{
normalizeCounts(counts, bins, GC = TRUE, map = TRUE, mc.cores = 1)
}
\arguments{
\item{counts}{A matrix of raw coverage output by calcCounts().}

\item{bins}{The set of bins determined by calcBins().}

\item{GC}{Whether to loess adjust for GC. Defaults to TRUE.}

\item{map}{Whether to loess adjust for mappability. Defaults to TRUE.
Defaults to 1.}

\item{mc.cores}{The number of cores to use for multi-threaded analysis.}
}
\value{
A \code{data.frame} of normalized counts. Each column is a sample,
and each row is a entry of \code{bins}.
}
\description{
This function will return a matrix of normalized M scores where ecah column 
is a sample, and each row is a bin.
}
\examples{
load(system.file("extdata", 'bins.RData', package = "MDTS"))
load(system.file("extdata", 'counts.RData', package = "MDTS"))
load(system.file("extdata", 'pD.RData', package = "MDTS"))
mCounts <- normalizeCounts(counts, bins)
}
\keyword{normalizeCounts}
