% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbeResults.R
\name{getProbeResults}
\alias{getProbeResults}
\title{Obtain probe results from a \code{ResultSet}}
\usage{
getProbeResults(
  object,
  rid = "DiffMean",
  coef = 2,
  contrast = NULL,
  fNames = c("chromosome", "start"),
  robust = FALSE,
  ...
)
}
\arguments{
\item{object}{ResultSet}

\item{rid}{Name of the results: "DiffMean" for mean differences, "DiffVar" for
variance differences. (Default: DiffMean)}

\item{coef}{Number of the coefficient used to compute the statistics. If a vector
is supplied, F-statistics evaluating the global effect of the coefficients are
computed. (Default: 2).}

\item{contrast}{Matrix of contrasts}

\item{fNames}{Names of the columns of \code{object} fData that will be added to 
the results data.frame.}

\item{...}{Further arguments passed to \code{getAssociation}.}
}
\value{
data.frame with the probe results.
}
\description{
It computes the statistics from the \code{MArrayLM} computed with 
\code{DiffMeanAnalysis} or \code{DiffVarAnalysis}. This function allows to 
specify the contrasts and to get F-statistics for a group of variables.
}
