% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultSet_plotRDA.R
\name{plotRDA}
\alias{plotRDA}
\title{Plot RDA results}
\usage{
plotRDA(object, pheno = data.frame(), n_feat = 5, main = "RDA plot", alpha = 1)
}
\arguments{
\item{object}{\code{ResultSet}}

\item{pheno}{data.frame with the variables used to color the samples.}

\item{n_feat}{Numeric with the number of cpgs to be highlighted. Default: 5.}

\item{main}{Character with the plot title.}

\item{alpha}{Numeric with the alpha level for colour transparance. Default: 1; no
transparency.}
}
\value{
A plot is generated on the current graphics device.
}
\description{
Plot RDA results
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
model <- model.matrix(~set$sex)
rda <- runRDA(set, model)
plotRDA(rda, pheno = data.frame(factor(set$sex)))
}
}
