% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scMEB.R
\name{scMEB}
\alias{scMEB}
\title{scMEB: A fast and clustering-independent method for detecting differentially 
expressed genes in single-cell RNA-seq data}
\usage{
scMEB(sce, stable_idx, filtered = FALSE, 
gamma = seq(1e-04,0.001,1e-05), nu = 0.01, reject_rate = 0.1)
}
\arguments{
\item{sce}{A SingleCellExperiment class scRNA-seq data.}

\item{stable_idx}{A vector shows the name of stable expressed gene in sce.}

\item{filtered}{A logical value to show if the data have been filtered.}

\item{gamma}{A parameter needed for all kernels except linear.}

\item{nu}{A parameter needed for one-classification.}

\item{reject_rate}{A value used in controling the scale of ball, default is
0.01.}
}
\value{
list(.) A list of results, "model" represents the model of scMEB,
which could be used to discriminate a new gene, "dat_pca" represents the 
first 50 PCs of each genes, "gamma" represents the selected gamma parameters 
in model scMEB, "train_error" represents the corresponding train_error when 
the value of gamma changed, "dist" shows the distance between the points and 
the radius of the sphere in feature space.
}
\description{
Using the Minimum Enclosing Ball (MEB) method to discriminate
differential expression genes (DEGs) without prior cell clustering results.
}
\examples{
## Simulation data for scRNA-seq data generated from splatter package.
library(SingleCellExperiment)
data(sim_scRNA_data)
data(stable_gene)
sim_scRNA <- scMEB(sce=sim_scRNA_data, stable_idx=stable_gene, 
filtered = FALSE, gamma = seq(1e-04,0.001,1e-05), nu = 0.01, 
reject_rate = 0.1)
}
