% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{rbindNamedList}
\alias{rbindNamedList}
\title{Combine data.tables from a named list into one big data.table with extra
column for name.}
\usage{
rbindNamedList(namedList, newColName = "sampleName")
}
\arguments{
\item{namedList}{A list of data.tables. One sample per data.table/list item.
Names of the list are the sample names.}

\item{newColName}{The name of the column that will be added to the data.tables}
}
\value{
mergedDT A single data.table that combines those in the input list 
(data.table::rbindlist)
but also added a column (default, newColName="sampleName") to each one to
keep track of which rows were from which sample
}
\description{
Combines data.tables from a list as data.table::rbindlist except an 
extra column is added which can mark which rows came from which 
original data.table. The name of this new column can be 
specified (newColName param) and the values are the names of the input list.
This function was originally intended for a list where each
data.table corresponds to a separate sample and the list names
correspond to the names of the samples. Now all samples can
be combined into one data.table but which sample the information
came from can be kept.
}
\examples{
# NOTE: generally sample names should be added after running aggregateMethyl() 
# rather than before in order to save memory (since data.table has less rows
# after aggregation)
data(exampleBSseqObj)
multiSampleList <- bsseqToDataTable(exampleBSseqObj)
combinedDT <- rbindNamedList(multiSampleList)
}
