% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_classes.R
\docType{class}
\name{MLSeqMetaData-class}
\alias{MLSeqMetaData-class}
\title{\code{MLSeqMetaData} object}
\description{
This object is a subclass for the \code{MLSeq} class. It contains metadata information, i.e. information on modified and/or
updated elements, raw data etc..
}
\details{
Objects can be created by calls of the form \code{new("MLSeqMetaData", ...)}. This type
of objects is created as a result of \code{classify} function of \code{MLSeq} package.
It is then used in \code{update} function for updating the object in given object.
}
\note{
The function \code{\link{update}} is used to re-run classification task with modified elements in \code{MLSeq} object. This function is
useful when one wish to perform classification task with modified options without running \code{classify} function from the beginning.
\code{MLSeqMetaData} object is used to store information on updated and/or modified elements in MLSeq object.

If an \code{MLSeq} object is modified, i.e. one or more elements in MLSeq object is replaced using related setter functions such as
\code{\link{method}}, \code{\link{ref}} etc., the slot \code{modified} becomes TRUE. Similarly, the slot \code{updated} stores the
information that the MLSeq object is updated (or classification task is re-runned) or not. If updated slot is FALSE and modified slot is TRUE, one
should run \code{\link{update}} to obtain the classification results by considering the modified elements.
}
\section{Slots}{


\describe{
  \item{\code{updated, modified}:}{a logical. See notes for details.}
  \item{\code{modified.elements}:}{a list containing the modified elements in \code{MLSeq} obejct.}
  \item{\code{rawData.DESeqDataSet}:}{raw data which is used for classification.}
  \item{\code{classLabel}:}{a character string indicating the name of class variable.}
}
}

\seealso{
\code{\link{update}}, \code{\link{isUpdated}}, \code{\link{isModified}}
}
