% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{method}
\alias{method}
\alias{method<-}
\alias{method,MLSeq-method}
\alias{method,MLSeqModelInfo-method}
\alias{method<-,MLSeq,character-method}
\title{Accessors for the 'method'.}
\usage{
method(object)

method(object) <- value

\S4method{method}{MLSeq}(object)

\S4method{method}{MLSeqModelInfo}(object)

\S4method{method}{MLSeq,character}(object) <- value
}
\arguments{
\item{object}{an \code{MLSeq} object.}

\item{value}{a character string. One of the available classification methods to replace with current method stored in MLSeq object.}
}
\description{
This slot stores the name of selected model which is used in \code{classify} function.
The trained model is stored in slot \code{trainedModel}.
See \code{\link{trained}} for details.
}
\details{
\code{method} slot stores the name of the classification method such as "svmRadial" for Radial-based Support Vector Machines, "rf" for Random Forests, "voomNSC" for
voom-based Nearest Shrunken Centroids, etc. For the complete list of available methods, see \code{\link{printAvailableMethods}} and \code{\link{availableMethods}}.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

method(cart)
}

}
\seealso{
\code{\link{trained}}
}
