% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{WeightedModulePartitionLouvain}
\alias{WeightedModulePartitionLouvain}
\title{Modules detection by Louvain algorithm}
\usage{
WeightedModulePartitionLouvain(datExpr, foldername, indicatename, GeneNames,
  maxsize = 200, minsize = 30, power = 6, tao = 0.2)
}
\arguments{
\item{datExpr}{gene expression profile, rows are samples and columns genes}

\item{foldername}{where to store the clusters}

\item{indicatename}{normally a specific tag of condition}

\item{GeneNames}{normally the gene official names to replace the colnames of datExpr}

\item{maxsize}{the maximal nodes allowed in one module}

\item{minsize}{the minimal nodes allowed in one module}

\item{power}{the power parameter of WGCNA, W_{ij}=|cor(x_i,x_j)|^power}

\item{tao}{the threshold to cut the adjacency matrix}
}
\value{
The number of clusters
}
\description{
Module detection based on the Louvain algorithm, which tries to maximize 
overall modularity of resulting partition.
}
\examples{
data(synthetic)
ResultFolder <- 'ForSynthetic' # where middle files are stored
indicator <- 'X'     # indicator for data profile 1
GeneNames <- colnames(datExpr1)
intModules1 <- WeightedModulePartitionLouvain(datExpr1,ResultFolder,indicator,GeneNames)
truemodule <- c(rep(1,100),rep(2,100),rep(3,100),rep(4,100),rep(5,100))
#mymodule <- getPartition(ResultFolder)
#randIndex(table(mymodule,truemodule),adjust=F)
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Blondel, Vincent D., et al. "Fast unfolding of communities in 
large networks." Journal of statistical mechanics: theory and experiment 
2008.10 (2008): P10008.
}
\keyword{cutting}
\keyword{dendrogram}

