% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{MOSimulator-class}
\alias{MOSimulator-class}
\title{Virtual class containing common methods and slots for child classes.}
\description{
Virtual class containing common methods and slots for child classes.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the simulator to be used in messages.}

\item{\code{data}}{Data frame containing the initial sample to be used, with the
features IDs as rownames and only one column named "Counts".}

\item{\code{regulator}}{Boolean flag to indicate if the omic is a regulator or not.}

\item{\code{regulatorEffect}}{Possible regulation effects of the omic (enhancer,
repressor or both).}

\item{\code{idToGene}}{Data frame with the association table between genes and other
features. The structure must be 2 columns, one named "ID" and the other
"Gene".}

\item{\code{min}}{Minimum value allowed in the omic.}

\item{\code{max}}{Maximum value allowed in the omic.}

\item{\code{depth}}{Sequencing depth to simulate.}

\item{\code{depthRound}}{Number of decimal places to round when adjusting depth.}

\item{\code{depthAdjust}}{Boolean indicating whether to adjust by sequencing depth or
not.}

\item{\code{totalFeatures}}{Number of features to simulate. This will replace the
data with a subset.}

\item{\code{noiseFunction}}{Noise function to apply when simulating counts. Must
accept the parameter 'n' and return a vector of the same length. Defaults
to `rnorm`}

\item{\code{increment}}{Read-only. Minimum value to increase when simulating counts.}

\item{\code{simData}}{Contains the final simulated data.}

\item{\code{pregenerated}}{Indicates if the child class will generate the simulated
data instead of the general process.}

\item{\code{randData}}{Auxiliary vector containing the original count data in random
order with other adjustments.}

\item{\code{noiseParams}}{Noise parameters to be used with noise function.}

\item{\code{roundDigits}}{Number of digits to round the simulated count values.}

\item{\code{minMaxQuantile}}{Numeric vector of length 2 indicating the quantiles to
use in order to retrieve the absolute minimum and maximum value that a
differentially expressed feature can have.}

\item{\code{minMaxFC}}{Numeric vector of length 2 indicating the minimum and maximum
fold-change that a differentially expressed feature can have.}

\item{\code{minMaxDist}}{Named list containing different minimum and maximum
constraints values calculated at the beginning of the simulation process.}

\item{\code{replicateParams}}{Named list containing the parameters a and b to be used
in the replicates generation process, see the vignette for more info.}
}}

\keyword{internal}
