% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsim_functions.R
\name{simulate_hyper}
\alias{simulate_hyper}
\title{Simulate technical variability}
\usage{
simulate_hyper(avgAbund, seqdepth = NULL, digits, max_val)
}
\arguments{
\item{avgAbund}{array containing the intensity values for each feature. It describes the intensity of a single sample}

\item{seqdepth}{sequencing depth (i.e. sample size of the MH)}

\item{digits}{number of digits for random number generation}

\item{max_val}{max value for random number generation}
}
\value{
An array of \code{length(avgAbund)} elements representing the count values for the current sample
}
\description{
Function to simulate the technical variability (i.e. a multivariate hypergeometric on a gamma expression value array)
}
\details{
This function is a copy of the `simulate_hyper` function from the
`SPARSim` package (v0.9.5), originally developed by Giacomo Baruzzo,
Ilaria Patuzzi, Barbara Di Camillo (2020). The original package is licensed
under the GPL-3 license.
}
