% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovrGMT.R
\name{ovrGMT}
\alias{ovrGMT}
\title{Calculate over-representation of gene sets in each sample by genes
from sample's largest sub-pathway}
\usage{
ovrGMT(subntwlist, fgmt, omic_genes = NULL, threads = 1)
}
\arguments{
\item{subntwlist}{A list of igraph objects represented the largest
sub-pathway for each sample. It is the output of
\code{subNtw()}.}

\item{fgmt}{A gene set GMT file. This will be the same file used for the
gene set over-representation calculation in the next step. It
is used here to ensure output sub-pathway contains a minimum
number of genes from to-be-used gene sets.}

\item{omic_genes}{A vector of gene symbols to narrow down
over-representation calculation to only those with input
genomic data. If not provided, all genes in the GMT file
will be considered. Default: NULL.}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A matrix containing over-representation adjusted P with rows as
gene set names and columns as sample IDs.
}
\description{
Calculate over-representation of gene sets in each sample by genes
from sample's largest sub-pathway
}
\examples{

fsubntwl  = system.file('extdata/subNtw/subntwl.rds',    package='MPAC')
fgmt      = system.file('extdata/ovrGMT/fake.gmt',       package='MPAC')
fomic_gns = system.file('extdata/TcgaInp/inp_focal.rds', package='MPAC')
subntwl  = readRDS(fsubntwl)
omic_gns = rownames(readRDS(fomic_gns))

ovrGMT(subntwl, fgmt, omic_gns)


}
