% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-write.R
\name{writeMSData,MSnExp,character-method}
\alias{writeMSData,MSnExp,character-method}
\alias{writeMSData}
\title{Write MS data to mzML or mzXML files}
\usage{
\S4method{writeMSData}{MSnExp,character}(
  object,
  file,
  outformat = c("mzml", "mzxml"),
  merge = FALSE,
  verbose = isMSnbaseVerbose(),
  copy = FALSE,
  software_processing = NULL
)
}
\arguments{
\item{object}{\code{OnDiskMSnExp} or \code{MSnExp} object.}

\item{file}{\code{character} with the file name(s). Its length has to match the
number of samples/files of \code{x}.}

\item{outformat}{\code{character(1)} defining the format of the output files.
Default output format is \code{"mzml"}.}

\item{merge}{\code{logical(1)} whether the data should be saved into a single
\emph{mzML} file. Default is \code{merge = FALSE}, i.e. each sample is saved to
a separate file. \strong{Note}: \code{merge = TRUE} is not yet implemented.}

\item{verbose}{\code{logical(1)} if progress messages should be displayed.}

\item{copy}{\code{logical(1)} if metadata (data processings, original file names
etc) should be copied from the original files. See details for more
information.}

\item{software_processing}{optionally provide specific data processing steps.
See documentation of the \code{software_processing} parameter of
\code{\link[mzR:writeMSData]{mzR::writeMSData()}}.}
}
\description{
The \verb{writeMSData,MSnExp} and \verb{writeMSData,OnDiskMSnExp} saves
the content of a \link{MSnExp} or \link{OnDiskMSnExp} object to MS file(s) in
either \emph{mzML} or \emph{mzXML} format.
}
\details{
The \code{writeMSData} method uses the \emph{proteowizard} libraries through
the \code{mzR} package to save the MS data. The data can be written to
\emph{mzML} or \emph{mzXML} files with or without copying additional metadata
information from the original files from which the data was read by the
\code{\link[=readMSData]{readMSData()}} function. This can be set using the \code{copy} parameter.
Note that \code{copy = TRUE} requires the original files to be available and
is not supported for input files in other than mzML or mzXML format.
All metadata related to the run is copied, such as instrument
information, data processings etc. If \code{copy = FALSE} only processing
information performed in R (using \code{MSnbase}) are saved to the mzML file.

Currently only spectrum data is supported, i.e. if the original mzML
file contains also chromatogram data it is not copied/saved to the new
mzML file.
}
\note{
General spectrum data such as total ion current, peak count, base peak
m/z or base peak intensity are calculated from the actual spectrum data
before writing the data to the files.

For MSn data, if the \code{OnDiskMSnExp} or \code{MSnExp} does not contain also
the precursor scan of a MS level > 1 spectrum (e.g. due to filtering on
the MS level) \code{precursorScanNum} is set to 0 in the output file to
avoid potentially linking to a wrong spectrum.

The exported \code{mzML} file \emph{should} be valid according to the mzML 1.1.2
standard. For exported \code{mzXML} files it can not be guaranteed that they
are valid and can be opened with other software than \code{mzR}/\code{MSnbase}.
}
\author{
Johannes Rainer
}
