% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_FragPipetoMSstatsFormat.R
\name{FragPipetoMSstatsFormat}
\alias{FragPipetoMSstatsFormat}
\title{Import FragPipe files}
\usage{
FragPipetoMSstatsFormat(
  input,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  summaryforMultipleRows = max,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{name of FragPipe msstats.csv export. ProteinName, PeptideSequence, PrecursorCharge, FragmentIon, ProductCharge, IsotopeLabelType, Condition, BioReplicate, Run, Intensity are required.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have only 1 feature, which is the combination of peptide, precursor charge, fragment and charge. FALSE is default.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple measurements for certain feature and certain run, use highest or sum of multiple intensities.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import FragPipe files
}
\examples{
fragpipe_raw = system.file("tinytest/raw_data/FragPipe/fragpipe_input.csv",
                              package = "MSstatsConvert")
fragpipe_raw = data.table::fread(fragpipe_raw)
fragpipe_imported = FragPipetoMSstatsFormat(fragpipe_raw, use_log_file = FALSE)
head(fragpipe_imported)

}
\author{
Devon Kohler
}
