% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters_MaxQtoMSstatsFormat.R
\name{MaxQtoMSstatsFormat}
\alias{MaxQtoMSstatsFormat}
\title{Import MaxQuant files}
\usage{
MaxQtoMSstatsFormat(
  evidence,
  annotation,
  proteinGroups,
  proteinID = "Proteins",
  useUniquePeptide = TRUE,
  summaryforMultipleRows = max,
  removeFewMeasurements = TRUE,
  removeMpeptides = FALSE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Peptide = FALSE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{evidence}{name of 'evidence.txt' data, which includes feature-level data.}

\item{annotation}{name of 'annotation.txt' data which includes Raw.file, Condition, BioReplicate, Run, IsotopeLabelType information.}

\item{proteinGroups}{name of 'proteinGroups.txt' data. It needs to matching protein group ID. If proteinGroups=NULL, use 'Proteins' column in 'evidence.txt'.}

\item{proteinID}{'Proteins'(default) or 'Leading.razor.protein' for Protein ID.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple measurements for certain feature and certain run, use highest or sum of multiple intensities.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements across runs.}

\item{removeMpeptides}{TRUE will remove the peptides including 'M' sequence. FALSE is default.}

\item{removeOxidationMpeptides}{TRUE will remove the peptides including 'oxidation (M)' in modification. FALSE is default.}

\item{removeProtein_with1Peptide}{TRUE will remove the proteins which have only 1 peptide and charge. FALSE is default.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{...}{additional parameters to \code{data.table::fread}.}
}
\value{
data.frame in the MSstats required format.
}
\description{
Import MaxQuant files
}
\note{
Warning: MSstats does not support for metabolic labeling or iTRAQ experiments.
}
\examples{
mq_ev = data.table::fread(system.file("tinytest/raw_data/MaxQuant/mq_ev.csv",
                                      package = "MSstatsConvert"))
mq_pg = data.table::fread(system.file("tinytest/raw_data/MaxQuant/mq_pg.csv",
                                      package = "MSstatsConvert"))
annot = data.table::fread(system.file("tinytest/raw_data/MaxQuant/annotation.csv",
                                      package = "MSstatsConvert"))
maxq_imported = MaxQtoMSstatsFormat(mq_ev, annot, mq_pg, use_log_file = FALSE)
head(maxq_imported)

}
\author{
Meena Choi, Olga Vitek.
}
