% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstatsConvert_core_functions.R
\name{getInputFile}
\alias{getInputFile}
\alias{getInputFile,MSstatsInputFiles-method}
\alias{getInputFile,MSstatsPhilosopherFiles-method}
\title{Get one of files contained in an instance of \code{MSstatsInputFiles} class.}
\usage{
getInputFile(msstats_object, file_type)

\S4method{getInputFile}{MSstatsInputFiles}(msstats_object, file_type = "input")

\S4method{getInputFile}{MSstatsPhilosopherFiles}(msstats_object, file_type = "input")
}
\arguments{
\item{msstats_object}{object that inherits from \code{MSstatsPhilosopherFiles} class.}

\item{file_type}{character name of a type file. Usually equal to "input".}
}
\value{
data.table

data.table

data.table
}
\description{
Get one of files contained in an instance of \code{MSstatsInputFiles} class.
}
\examples{
evidence_path = system.file("tinytest/raw_data/MaxQuant/mq_ev.csv", 
                            package = "MSstatsConvert")
pg_path = system.file("tinytest/raw_data/MaxQuant/mq_pg.csv", 
                      package = "MSstatsConvert")
evidence = read.csv(evidence_path)
pg = read.csv(pg_path)
imported = MSstatsImport(list(evidence = evidence, protein_groups = pg),
                         "MSstats", "MaxQuant")
class(imported)
head(getInputFile(imported, "evidence"))
}
