% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trypticHistogramLiP.R
\name{trypticHistogramLiP}
\alias{trypticHistogramLiP}
\title{Histogram of Half vs Fully tryptic peptides. Calculates proteotypicity,
and then uses calcualtions in histogram.}
\usage{
trypticHistogramLiP(
  data,
  fasta,
  x.axis.size = 10,
  y.axis.size = 10,
  legend.size = 10,
  width = 12,
  height = 4,
  color_scale = "bright",
  address = "",
  isPlotly = FALSE
)
}
\arguments{
\item{data}{output of MSstatsLiP converter function. Must include at least
ProteinName, PeptideSequence, BioReplicate, and Condition columns}

\item{fasta}{A string of path to a FASTA file, used to match LiP peptides.}

\item{x.axis.size}{size of x-axis labeling for plot. Default is 10.}

\item{y.axis.size}{size of y-axis labeling for plot. Default is 10.}

\item{legend.size}{size of feature legend for half vs fully tryptic peptides
below graph. Default is 7.}

\item{width}{Width of final pdf to be plotted}

\item{height}{Height of final pdf to be plotted}

\item{color_scale}{colors of bar chart. Must be one of "bright" or "grey".
Default is "bright".}

\item{address}{the name of folder that will store the results. Default folder
is the current working directory. The other assigned folder has to be
existed under the current working directory. An output pdf file is
automatically created with the default name of "TyrpticPlot.pdf". If
address=FALSE, plot will be not saved as pdf file but shown in window..}

\item{isPlotly}{Parameter to use Plotly or ggplot2. If set to TRUE, MSstats
will save Plotly plots as HTML files. If set to FALSE MSstats will save ggplot2 plots
as PDF files}
}
\value{
plot or pdf
}
\description{
Histogram of Half vs Fully tryptic peptides. Calculates proteotypicity,
and then uses calcualtions in histogram.
}
\examples{
# Use output of summarization function
trypticHistogramLiP(MSstatsLiP_Summarized,
                    system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP"),
                    color_scale = "bright", address = FALSE)

}
