% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointEstimator.R
\name{ChangePointEstimator}
\alias{ChangePointEstimator}
\title{A function to identify the time of a change in the mean or variability of a metric}
\usage{
ChangePointEstimator(
  data = NULL,
  peptide,
  L = 1,
  U = 5,
  metric,
  normalization = TRUE,
  ytitle = "Change Point Plot - mean",
  type = "mean",
  selectMean = NULL,
  selectSD = NULL
)
}
\arguments{
\item{data}{comma-separated (.csv), metric file. It should contain a "Precursor" column and the metrics columns. It should also include "Annotations" for each observation.}

\item{peptide}{the name of precursor of interest.}

\item{L}{Lower bound of the guide set.}

\item{U}{Upper bound of the guide set.}

\item{metric}{the name of metric of interest.}

\item{normalization}{TRUE metric is standardized and FALSE if not standardized.}

\item{ytitle}{the y-axis title of the plot.  Defaults to "Change Point Plot - mean". The x-axis title is by default "QCno-name of peptide"}

\item{type}{the type of the control chart. Two values can be assigned, "mean" or "variability". Default is "mean".}

\item{selectMean}{the mean of a metric. It is used when mean is known. It is NULL when mean is not known.  The default is NULL.}

\item{selectSD}{the standard deviation of a metric. It is used when standard deviation is known. It is NULL when mean is not known. The default is NULL.}
}
\value{
A plot of likelihood statistics versus time per peptide and metric generated from \code{CP.data.prepare} data frame.
}
\description{
A function to identify the time of a change in the mean or variability of a metric
}
\examples{
# First process the data to make sure it's ready to use
sampleData <- DataProcess(S9Site54)
head(sampleData)
# Find the name of the peptides
levels(sampleData$Precursor)
# Calculate change point statistics
ChangePointEstimator(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime")
ChangePointEstimator(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime",
                     ytitle = "Change Point Plot - variability", type = "variability")
ChangePointEstimator(data = sampleData, peptide = "VLVLDTDYK", metric = "BestRetentionTime",
                     selectMean = 27.78, selectSD = 8.19)
ChangePointEstimator(data = sampleData, peptide = "DDGSWEVIEGYR", metric = "TotalArea")
ChangePointEstimator(data = sampleData, peptide = "DDGSWEVIEGYR", metric = "TotalArea",
                     selectMean = 35097129, selectSD = 34132861)
ChangePointEstimator(data = sampleData, peptide = "TAAYVNAIEK", metric = "MaxFWHM")
}
\keyword{change}
\keyword{chart}
\keyword{control}
\keyword{point,}
