\name{JBA_plotBins}
\alias{JBA_plotBins}
\title{Visualization of JBA bins}
\description{
This function allows visualizing the bins generated by the JBA algorithm.
}
\usage{
JBA_plotBins(NMR_JBA, NMR_data, ct = 0.85, ref_sample = 1, xlim = NULL, 
             ylim = NULL)
}
\arguments{
  \item{NMR_JBA}{list corresponding to the output of "JBA_binning()".}
  \item{NMR_data}{numeric matrix containing the NMR data (i.e. NMR peak intensities). 
  The columns of the matrix must correspond to the metabolic variables (chemical shifts) 
  and the rows to the samples. Column and row names must contain the metabolite IDs 
  (i.e chemical shifts) and the sample IDs, respectively.}
  \item{ct}{numeric value indicating the correlation threshold. Bins with average correlation 
  below ct will be neglected. This value can be established by comparing the distribution 
  of average correlations in a spectral region dominated by electronic noise, and a spectral
  region dominated by metabolic signals. See function "JBA_corDistribution()". }
  \item{ref_sample}{numeric value indicating the index of the reference spectrum.}
  \item{xlim}{numeric vector containing the minimum and maximum values of the x axis.}
  \item{ylim}{numeric vector containing the minimum and maximum values of the y axis.}
}
\value{
A plot with two panels. The upper panel shows the reference spectrum with the bin
edges (start: dark blue, end: light blue). The lowe panel shows the corresponding
correlation-based spectrum. 
}
\examples{
## Not available.
}