% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{cv}
\alias{cv}
\title{Calculate coefficient of variation}
\usage{
cv(x, name = "raw")
}
\arguments{
\item{x}{\code{matrix}}

\item{name}{\code{character}, the name of the returned list}
}
\value{
\code{list}
}
\description{
The function \code{cv} calculates the coefficient of variation from columns  
of a matrix. The coefficients of variation are calculated according to the 
formula \code{sd(y) / mean(y) * 100} with \code{y} the column values, thus,
the function returns the coefficient of variation in percentage.
}
\details{
The function returned a named \code{list} (the name is specified by the 
\code{name} argument) containing the coefficient of variation of the 
columns of \code{x}.
}
\examples{
x <- matrix(seq_len(10), ncol = 2)
cv(x)

}
