% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{cvFeaturePlot}
\alias{cvFeaturePlot}
\title{Plot of feature-wise coefficient of variation values}
\usage{
cvFeaturePlot(l, lines = FALSE)
}
\arguments{
\item{l}{\code{list} containing matrices}

\item{lines}{\code{logical}}
}
\value{
\code{plotly}
}
\description{
The function \code{cvFeaturePlot} returns a \code{plotly} plot of coefficient 
of variation values. It will create a violin plot and superseded points
of coefficient of variation values per list entry of \code{l}.
}
\details{
\code{lines = TRUE} will connect the points belonging to the same feature 
with a line. If there are less than two features, the violin plot will not be
plotted. The violin plots will be ordered according to the order in \code{l}
}
\examples{
x1 <- matrix(seq_len(100), ncol = 10, nrow = 10, 
    dimnames = list(paste("feature", seq_len(10)), 
        paste("sample", seq_len(10))))
x2 <- x1 + 5
x3 <- x2 + 10
l <- list(x1 = x1, x2 = x2, x3 = x3)
cvFeaturePlot(l, lines = FALSE)

}
